"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddableAttributes = void 0;
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _lens_attributes = require("../configurations/lens_attributes");
var _use_lens_attributes = require("../hooks/use_lens_attributes");
var _obsv_exploratory_view = require("../obsv_exploratory_view");
var _ = require("../../../..");
var _single_metric_attributes = require("../configurations/lens_attributes/single_metric_attributes");
var _heatmap_attributes = require("../configurations/lens_attributes/heatmap_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEmbeddableAttributes = ({
  attributes,
  dataViewState,
  reportType,
  reportConfigMap = {},
  dslFilters
}) => {
  var _spaceId$space2;
  const spaceId = (0, _public.useKibanaSpace)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => {
    try {
      var _spaceId$space;
      const layerConfigs = (0, _use_lens_attributes.getLayerConfigs)(attributes, reportType, euiTheme, dataViewState, {
        ...reportConfigMap,
        ..._obsv_exploratory_view.obsvReportConfigMap
      }, (_spaceId$space = spaceId.space) === null || _spaceId$space === void 0 ? void 0 : _spaceId$space.id);
      if (reportType === _.ReportTypes.SINGLE_METRIC) {
        const lensAttributes = new _single_metric_attributes.SingleMetricLensAttributes(layerConfigs, reportType, dslFilters);
        return lensAttributes === null || lensAttributes === void 0 ? void 0 : lensAttributes.getJSON('lnsLegacyMetric');
      } else if (reportType === _.ReportTypes.HEATMAP) {
        const lensAttributes = new _heatmap_attributes.HeatMapLensAttributes(layerConfigs, reportType);
        return lensAttributes === null || lensAttributes === void 0 ? void 0 : lensAttributes.getJSON('lnsHeatmap');
      } else {
        const lensAttributes = new _lens_attributes.LensAttributes(layerConfigs, reportType, dslFilters);
        return lensAttributes === null || lensAttributes === void 0 ? void 0 : lensAttributes.getJSON();
      }
    } catch (error) {
      console.error(error);
    }
  }, [attributes, dataViewState, dslFilters, euiTheme, reportConfigMap, reportType, (_spaceId$space2 = spaceId.space) === null || _spaceId$space2 === void 0 ? void 0 : _spaceId$space2.id]);
};
exports.useEmbeddableAttributes = useEmbeddableAttributes;