"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoValidCallSignatureError = void 0;
var _errors = require("../errors");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// used for testing... eventually should be moved to the __tests__ directory once
// kbn-esql-validation-autocomplete is merged into this package and this no longer
// has to be exported from this package
const getNoValidCallSignatureError = (fnName, givenTypes) => {
  const definition = (0, _functions.buildFunctionLookup)().get(fnName);
  return `Invalid input types for ${fnName.toUpperCase()}.

Received (${givenTypes.join(', ')}).

Expected one of:\n  ${[...definition.signatures].sort((a, b) => a.params.length - b.params.length).map(sig => `- (${(0, _errors.buildSignatureTypes)(sig)})`).join('\n  ')}`;
};
exports.getNoValidCallSignatureError = getNoValidCallSignatureError;