"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateOption = validateOption;
var _is = require("../../../ast/is");
var _column = require("./column");
var _function = require("./function");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function validateOption(option, command, ast, context, callbacks) {
  // check if the arguments of the option are of the correct type
  const messages = [];
  if (option.incomplete || command.incomplete || option.name === 'metadata') {
    return messages;
  }
  if (option.name === 'metadata') {
    // Validation for the metadata statement is handled in the FROM command's validate method
    return messages;
  }
  for (const arg of option.args) {
    if (Array.isArray(arg)) {
      continue;
    }
    if ((0, _is.isColumn)(arg)) {
      messages.push(...(0, _column.validateColumnForCommand)(arg, command.name, context));
    } else if ((0, _is.isFunctionExpression)(arg)) {
      messages.push(...(0, _function.validateFunction)({
        fn: arg,
        parentCommand: command,
        ast,
        context,
        callbacks
      }));
    }
  }
  return messages;
}