"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildMissingMetadataMessage = buildMissingMetadataMessage;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function buildMissingMetadataMessage(command, metadataField) {
  return {
    location: command.location,
    text: _i18n.i18n.translate('kbn-esql-ast.esql.validation.fuseMissingMetadata', {
      defaultMessage: `[FUSE] The FROM command is missing the {metadataField} METADATA field.`,
      values: {
        metadataField
      }
    }),
    type: 'error',
    code: `fuseMissingMetadata`
  };
}