"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../../complete_items");
var _sources = require("../../../definitions/utils/sources");
var _metadata = require("../../options/metadata");
var _recommended_queries = require("../../options/recommended_queries");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _shared = require("../../../definitions/utils/shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  const innerText = query.substring(0, cursorPosition);
  if ((0, _helpers.withinQuotes)(innerText) || !(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const suggestions = [];
  const indexes = (0, _sources.getSourcesFromCommands)([command], 'index');
  const metadataSuggestions = (0, _metadata.getMetadataSuggestions)(command, innerText);
  if (metadataSuggestions) {
    return metadataSuggestions;
  }
  const metadataOverlap = (0, _shared.getOverlapRange)(innerText, 'METADATA');

  // FROM /
  if (indexes.length === 0) {
    var _context$sources;
    suggestions.push(...(0, _sources.getSourceSuggestions)((_context$sources = context === null || context === void 0 ? void 0 : context.sources) !== null && _context$sources !== void 0 ? _context$sources : [], indexes.map(({
      name
    }) => name)));
  }
  // FROM something /
  else if (indexes.length > 0 && /\s$/.test(innerText) && !(0, _shared.isRestartingExpression)(innerText)) {
    var _context$editorExtens;
    suggestions.push(_metadata.metadataSuggestion);
    suggestions.push(_complete_items.commaCompleteItem);
    suggestions.push(_complete_items.pipeCompleteItem);
    suggestions.push(...(await (0, _recommended_queries.getRecommendedQueriesSuggestions)((_context$editorExtens = context === null || context === void 0 ? void 0 : context.editorExtensions) !== null && _context$editorExtens !== void 0 ? _context$editorExtens : {
      recommendedFields: [],
      recommendedQueries: []
    }, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getByType)));
  }
  // FROM something MET/
  else if (indexes.length > 0 && /^FROM\s+\S+\s+/i.test(innerText) && metadataOverlap) {
    suggestions.push(_metadata.metadataSuggestion);
  }
  // FROM someth/
  // FROM something/
  // FROM something, /
  else if (indexes.length) {
    var _context$sources2, _context$editorExtens2;
    const sources = (_context$sources2 = context === null || context === void 0 ? void 0 : context.sources) !== null && _context$sources2 !== void 0 ? _context$sources2 : [];
    const recommendedQuerySuggestions = await (0, _recommended_queries.getRecommendedQueriesSuggestions)((_context$editorExtens2 = context === null || context === void 0 ? void 0 : context.editorExtensions) !== null && _context$editorExtens2 !== void 0 ? _context$editorExtens2 : {
      recommendedFields: [],
      recommendedQueries: []
    }, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getByType);
    const additionalSuggestions = await (0, _sources.additionalSourcesSuggestions)(innerText, sources, indexes.map(({
      name
    }) => name), recommendedQuerySuggestions);
    suggestions.push(...additionalSuggestions);
  }
  return suggestions;
}