"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _expressions = require("../../../definitions/utils/expressions");
var _validation = require("../../../definitions/utils/validation");
var _errors = require("../../../definitions/utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const supportedPromptTypes = ['text', 'keyword', 'unknown', 'param'];
const validate = (command, ast, context, callbacks) => {
  const messages = [];
  const {
    prompt,
    location,
    inferenceId
  } = command;
  const promptExpressionType = (0, _expressions.getExpressionType)(prompt, context === null || context === void 0 ? void 0 : context.columns);
  if (!supportedPromptTypes.includes(promptExpressionType)) {
    messages.push(_errors.errors.byId('unsupportedQueryType', 'location' in prompt ? prompt === null || prompt === void 0 ? void 0 : prompt.location : location, {
      command: 'COMPLETION',
      expressionType: promptExpressionType
    }));
  }
  if (inferenceId !== null && inferenceId !== void 0 && inferenceId.incomplete) {
    messages.push(_errors.errors.byId('inferenceIdRequired', command.location, {
      command: 'COMPLETION'
    }));
  }
  messages.push(...(0, _validation.validateCommandArguments)(command, ast, context, callbacks));
  return messages;
};
exports.validate = validate;