"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.completionCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _columns_after = require("./columns_after");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const completionCommandMethods = {
  validate: _validate.validate,
  autocomplete: _autocomplete.autocomplete,
  columnsAfter: _columns_after.columnsAfter
};
const completionCommand = exports.completionCommand = {
  name: 'completion',
  methods: completionCommandMethods,
  metadata: {
    preview: true,
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.completionDoc', {
      defaultMessage: 'Send prompts to an LLM. Requires an inference endpoint set up for `completion` tasks.'
    }),
    declaration: `COMPLETION <prompt> WITH <inferenceId> (AS <targetField>)`,
    examples: []
  }
};