"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _uniqBy = _interopRequireDefault(require("lodash/uniqBy"));
var _leaf_printer = require("../../../pretty_print/leaf_printer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const columnsAfter = (command, previousColumns, query) => {
  const {
    targetField
  } = command;
  return (0, _uniqBy.default)([...previousColumns, targetField ? {
    name: _leaf_printer.LeafPrinter.column(targetField),
    type: 'keyword',
    userDefined: true,
    location: targetField.location
  } : {
    name: 'completion',
    type: 'keyword',
    userDefined: false
  }], 'name');
};
exports.columnsAfter = columnsAfter;