"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.querySchema = exports.aggregateQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const querySchema = exports.querySchema = _configSchema.schema.object({
  query: _configSchema.schema.oneOf([_configSchema.schema.string({
    meta: {
      description: 'A text-based query such as Kibana Query Language (KQL) or Lucene query language.'
    }
  }), _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())]),
  language: _configSchema.schema.string()
});
const aggregateQuerySchema = exports.aggregateQuerySchema = _configSchema.schema.object({
  esql: _configSchema.schema.string()
});