"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchQueryOrThrow = getElasticsearchQueryOrThrow;
var _esQuery = require("@kbn/es-query");
var _invalid_transform_error = require("../errors/invalid_transform_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticsearchQueryOrThrow(kuery) {
  try {
    return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery));
  } catch (err) {
    throw new _invalid_transform_error.InvalidTransformError(`Invalid KQL: ${kuery}`);
  }
}