"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENTITY_LATEST_PREFIX_V1 = exports.ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1 = exports.ENTITY_INTERNAL_INDICES_PATTERN = exports.ENTITY_HISTORY_PREFIX_V1 = exports.ENTITY_HISTORY_ILM_POLICY = exports.ENTITY_HISTORY_BASE_COMPONENT_TEMPLATE_V1 = exports.ENTITY_EVENT_COMPONENT_TEMPLATE_V1 = exports.ENTITY_ENTITY_COMPONENT_TEMPLATE_V1 = exports.ENTITY_DEFAULT_METADATA_LIMIT = exports.ENTITY_DEFAULT_MAX_PAGE_SEARCH_SIZE = exports.ENTITY_DEFAULT_LATEST_SYNC_DELAY = exports.ENTITY_DEFAULT_LATEST_FREQUENCY = exports.ECS_MAPPINGS_COMPONENT_TEMPLATE = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Base constants
const ENTITY_INTERNAL_INDICES_PATTERN = exports.ENTITY_INTERNAL_INDICES_PATTERN = `.${_entitiesSchema.ENTITY_BASE_PREFIX}*`;
const ENTITY_ENTITY_COMPONENT_TEMPLATE_V1 = exports.ENTITY_ENTITY_COMPONENT_TEMPLATE_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_entity`;
const ENTITY_EVENT_COMPONENT_TEMPLATE_V1 = exports.ENTITY_EVENT_COMPONENT_TEMPLATE_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_event`;
const ECS_MAPPINGS_COMPONENT_TEMPLATE = exports.ECS_MAPPINGS_COMPONENT_TEMPLATE = 'ecs@mappings';

// History constants
const ENTITY_HISTORY_BASE_COMPONENT_TEMPLATE_V1 = exports.ENTITY_HISTORY_BASE_COMPONENT_TEMPLATE_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_HISTORY}_base`;
const ENTITY_HISTORY_PREFIX_V1 = exports.ENTITY_HISTORY_PREFIX_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}-${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}-${_entitiesSchema.ENTITY_HISTORY}`;
const ENTITY_HISTORY_ILM_POLICY = exports.ENTITY_HISTORY_ILM_POLICY = `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_HISTORY}_ilm_policy`;

// Latest constants
const ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1 = exports.ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}_${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}_${_entitiesSchema.ENTITY_LATEST}_base`;
const ENTITY_LATEST_PREFIX_V1 = exports.ENTITY_LATEST_PREFIX_V1 = `${_entitiesSchema.ENTITY_BASE_PREFIX}-${_entitiesSchema.ENTITY_SCHEMA_VERSION_V1}-${_entitiesSchema.ENTITY_LATEST}`;

// Transform constants
const ENTITY_DEFAULT_LATEST_FREQUENCY = exports.ENTITY_DEFAULT_LATEST_FREQUENCY = '1m';
const ENTITY_DEFAULT_LATEST_SYNC_DELAY = exports.ENTITY_DEFAULT_LATEST_SYNC_DELAY = '60s';
const ENTITY_DEFAULT_METADATA_LIMIT = exports.ENTITY_DEFAULT_METADATA_LIMIT = 10;
const ENTITY_DEFAULT_MAX_PAGE_SEARCH_SIZE = exports.ENTITY_DEFAULT_MAX_PAGE_SEARCH_SIZE = 500;