"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorsSearchResultProvider = getConnectorsSearchResultProvider;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _constants = require("../../common/constants");
var _calculate_search_score = require("./calculate_search_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorsSearchResultProvider(staticAssets) {
  return {
    find: ({
      term,
      types,
      tags
    }, {
      aborted$,
      client,
      maxResults
    }, {
      core: {
        capabilities
      }
    }) => {
      if (!client || !term || tags || types && !types.includes('connector')) {
        return (0, _rxjs.from)([[]]);
      }
      const getConnectorData = async () => {
        const connectorData = await (0, _searchConnectors.fetchConnectors)(client.asCurrentUser, undefined, false, term);
        const searchResults = connectorData.map(({
          name,
          id
        }) => {
          const score = (0, _calculate_search_score.calculateScore)(term, name);
          return {
            icon: staticAssets.getPluginAssetHref('images/connector.svg'),
            id: name,
            score,
            title: name,
            type: _i18n.i18n.translate('xpack.enterpriseSearch.searchConnectorProvider.type.name', {
              defaultMessage: 'Connector'
            }),
            url: {
              path: `${_constants.ENTERPRISE_SEARCH_DATA_PLUGIN.URL}/connectors/${id}`,
              prependBasePath: true
            }
          };
        }).filter(result => result.score > 0).slice(0, maxResults);
        return searchResults;
      };
      return capabilities.pipe((0, _rxjs.takeUntil)(aborted$), (0, _rxjs.switchMap)(caps => {
        if (!caps.catalogue.enterpriseSearch) {
          return (0, _rxjs.of)([]);
        }
        return (0, _rxjs.from)(getConnectorData());
      }));
    },
    getSearchableTypes: () => ['connector'],
    id: 'enterpriseSearchConnectors'
  };
}