"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reportAttackDiscoverySuccessTelemetry = exports.attackDiscoveryStatus = void 0;
var _moment = _interopRequireDefault(require("moment/moment"));
var _telemetry = require("./telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const attackDiscoveryStatus = exports.attackDiscoveryStatus = {
  canceled: 'canceled',
  failed: 'failed',
  running: 'running',
  succeeded: 'succeeded'
};
const reportAttackDiscoverySuccessTelemetry = ({
  anonymizedAlerts,
  apiConfig,
  attackDiscoveries,
  hasFilter,
  end,
  logger,
  size,
  start,
  startTime,
  telemetry
}) => {
  try {
    const endTime = (0, _moment.default)();
    const durationMs = endTime.diff(startTime);
    const alertsContextCount = anonymizedAlerts.length;
    (0, _telemetry.reportAttackDiscoveryGenerationSuccess)({
      alertsContextCount,
      apiConfig,
      attackDiscoveries,
      durationMs,
      end,
      hasFilter,
      size,
      start,
      telemetry
    });
  } catch (err) {
    logger.error(`Failed to report attack discovery success telemetry: ${err}`);
  }
};
exports.reportAttackDiscoverySuccessTelemetry = reportAttackDiscoverySuccessTelemetry;