"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRetrieveAnonymizedDocsOrGenerateEdge = void 0;
var _get_retrieve_or_generate = require("./get_retrieve_or_generate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRetrieveAnonymizedDocsOrGenerateEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---RETRIEVE ANONYMIZED DOCS OR GENERATE---');
    const {
      anonymizedDocuments
    } = state;
    const decision = (0, _get_retrieve_or_generate.getRetrieveOrGenerate)(anonymizedDocuments);
    logger === null || logger === void 0 ? void 0 : logger.debug(() => `retrieveAnonymizedDocsOrGenerateEdge evaluated the following (derived) state:\n${JSON.stringify({
      anonymizedDocuments: anonymizedDocuments.length
    }, null, 2)}
        \n---RETRIEVE ANONYMIZED DOCS OR GENERATE: ${decision}---`);
    return decision;
  };
  return edge;
};
exports.getRetrieveAnonymizedDocsOrGenerateEdge = getRetrieveAnonymizedDocsOrGenerateEdge;