"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryPrompts = void 0;
var _prompt = require("../../../../prompt");
var _local_prompt_object = require("../../../../prompt/local_prompt_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAttackDiscoveryPrompts = async ({
  actionsClient,
  connector,
  connectorId,
  model,
  provider,
  savedObjectsClient
}) => {
  var _prompts$find, _prompts$find2, _prompts$find3, _prompts$find4, _prompts$find5, _prompts$find6, _prompts$find7, _prompts$find8, _prompts$find9;
  const prompts = await (0, _prompt.getPromptsByGroupId)({
    actionsClient,
    connector,
    connectorId,
    // if in future oss has different prompt, add it as model here
    model,
    promptGroupId: _local_prompt_object.promptGroupId.attackDiscovery,
    promptIds: [_prompt.promptDictionary.attackDiscoveryDefault, _prompt.promptDictionary.attackDiscoveryRefine, _prompt.promptDictionary.attackDiscoveryContinue, _prompt.promptDictionary.attackDiscoveryDetailsMarkdown, _prompt.promptDictionary.attackDiscoveryEntitySummaryMarkdown, _prompt.promptDictionary.attackDiscoveryMitreAttackTactics, _prompt.promptDictionary.attackDiscoverySummaryMarkdown, _prompt.promptDictionary.attackDiscoveryGenerationTitle, _prompt.promptDictionary.attackDiscoveryGenerationInsights],
    provider,
    savedObjectsClient
  });
  return {
    default: ((_prompts$find = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryDefault)) === null || _prompts$find === void 0 ? void 0 : _prompts$find.prompt) || '',
    refine: ((_prompts$find2 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryRefine)) === null || _prompts$find2 === void 0 ? void 0 : _prompts$find2.prompt) || '',
    continue: ((_prompts$find3 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryContinue)) === null || _prompts$find3 === void 0 ? void 0 : _prompts$find3.prompt) || '',
    detailsMarkdown: ((_prompts$find4 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryDetailsMarkdown)) === null || _prompts$find4 === void 0 ? void 0 : _prompts$find4.prompt) || '',
    entitySummaryMarkdown: ((_prompts$find5 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryEntitySummaryMarkdown)) === null || _prompts$find5 === void 0 ? void 0 : _prompts$find5.prompt) || '',
    mitreAttackTactics: ((_prompts$find6 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryMitreAttackTactics)) === null || _prompts$find6 === void 0 ? void 0 : _prompts$find6.prompt) || '',
    summaryMarkdown: ((_prompts$find7 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoverySummaryMarkdown)) === null || _prompts$find7 === void 0 ? void 0 : _prompts$find7.prompt) || '',
    title: ((_prompts$find8 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryGenerationTitle)) === null || _prompts$find8 === void 0 ? void 0 : _prompts$find8.prompt) || '',
    insights: ((_prompts$find9 = prompts.find(prompt => prompt.promptId === _prompt.promptDictionary.attackDiscoveryGenerationInsights)) === null || _prompts$find9 === void 0 ? void 0 : _prompts$find9.prompt) || ''
  };
};
exports.getAttackDiscoveryPrompts = getAttackDiscoveryPrompts;