"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExampleInputWithOverrides = exports.ExampleInput = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Document = _zod.z.object({
  pageContent: _zod.z.string(),
  metadata: _zod.z.record(_zod.z.string(), _zod.z.any())
});
/**
 * Parses the input from an example in a LangSmith dataset
 */
const ExampleInput = exports.ExampleInput = _zod.z.object({
  attackDiscoveries: _zod.z.array(_elasticAssistantCommon.AttackDiscovery).nullable().optional(),
  attackDiscoveryPrompt: _zod.z.string().optional(),
  anonymizedAlerts: _zod.z.array(Document).optional(),
  anonymizedDocuments: _zod.z.array(Document).optional(),
  combinedGenerations: _zod.z.string().optional(),
  combinedRefinements: _zod.z.string().optional(),
  errors: _zod.z.array(_zod.z.string()).optional(),
  generationAttempts: _zod.z.number().optional(),
  generations: _zod.z.array(_zod.z.string()).optional(),
  hallucinationFailures: _zod.z.number().optional(),
  insights: _zod.z.array(_elasticAssistantCommon.AttackDiscovery).nullable().optional(),
  maxGenerationAttempts: _zod.z.number().optional(),
  maxHallucinationFailures: _zod.z.number().optional(),
  maxRepeatedGenerations: _zod.z.number().optional(),
  refinements: _zod.z.array(_zod.z.string()).optional(),
  refinePrompt: _zod.z.string().optional(),
  replacements: _elasticAssistantCommon.Replacements.optional(),
  unrefinedResults: _zod.z.array(_elasticAssistantCommon.AttackDiscovery).nullable().optional()
});
/**
 * The optional overrides for an example input
 */
const ExampleInputWithOverrides = exports.ExampleInputWithOverrides = _zod.z.intersection(ExampleInput, _zod.z.object({
  overrides: ExampleInput.optional()
}));