"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetAttackDiscoveryGenerationResponse = exports.GetAttackDiscoveryGenerationRequestQuery = exports.GetAttackDiscoveryGenerationRequestParams = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common_attributes = require("../../../../common_attributes.gen");
var _attack_discovery_api_alert = require("../../../attack_discovery_api_alert.gen");
var _generation = require("../../../generation.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Get Attack discovery generation API endpoint
 *   version: 2023-10-31
 */

const GetAttackDiscoveryGenerationRequestQuery = exports.GetAttackDiscoveryGenerationRequestQuery = _zod.z.object({
  /**
   * Enables a markdown syntax used to render pivot fields, for example `{{ user.name james }}`. When disabled, the same example would be rendered as `james`. This is primarily used for Attack discovery views within Kibana. Defaults to `false`.
   */
  enable_field_rendering: _zodHelpers.BooleanFromString.optional().default(false),
  /**
   * When true, return the created Attack discoveries with text replacements applied to the detailsMarkdown, entitySummaryMarkdown, summaryMarkdown, and title fields. Defaults to `true`.
   */
  with_replacements: _zodHelpers.BooleanFromString.optional().default(true)
});
const GetAttackDiscoveryGenerationRequestParams = exports.GetAttackDiscoveryGenerationRequestParams = _zod.z.object({
  /**
   * The unique identifier for the Attack discovery generation execution. This UUID is returned at the start of an Attack discovery generation.
   */
  execution_uuid: _common_attributes.NonEmptyString
});
const GetAttackDiscoveryGenerationResponse = exports.GetAttackDiscoveryGenerationResponse = _zod.z.object({
  /**
   * Array of Attack discoveries generated during this execution.
   */
  data: _zod.z.array(_attack_discovery_api_alert.AttackDiscoveryApiAlert),
  /**
   * Optional metadata about the attack discovery generation process, metadata including execution status and statistics. This metadata may not be available for all generations.
   */
  generation: _generation.AttackDiscoveryGeneration.optional()
});