"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilesManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _utils = require("./utils");
var _scoped_profiles_manager = require("./scoped_profiles_manager");
var _consts = require("./consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Result of resolving the root profile
 */

class ProfilesManager {
  constructor(rootProfileService, dataSourceProfileService, documentProfileService) {
    (0, _defineProperty2.default)(this, "rootProfile", void 0);
    (0, _defineProperty2.default)(this, "prevRootProfileParams", void 0);
    (0, _defineProperty2.default)(this, "rootProfileAbortController", void 0);
    (0, _defineProperty2.default)(this, "rootContext$", void 0);
    this.rootProfileService = rootProfileService;
    this.dataSourceProfileService = dataSourceProfileService;
    this.documentProfileService = documentProfileService;
    this.rootContext$ = new _rxjs.BehaviorSubject(rootProfileService.defaultContext);
    this.rootProfile = rootProfileService.getProfile({
      context: this.rootContext$.getValue()
    });
    this.rootContext$.pipe((0, _rxjs.skip)(1)).subscribe(context => {
      this.rootProfile = rootProfileService.getProfile({
        context
      });
    });
  }

  /**
   * Resolves the root context profile
   * @param params The root profile provider parameters
   */
  async resolveRootProfile(params) {
    var _this$rootProfileAbor;
    const serializedParams = serializeRootProfileParams(params);
    if ((0, _lodash.isEqual)(this.prevRootProfileParams, serializedParams)) {
      return {
        getRenderAppWrapper: this.rootProfile.getRenderAppWrapper,
        getDefaultAdHocDataViews: this.rootProfile.getDefaultAdHocDataViews
      };
    }
    const abortController = new AbortController();
    (_this$rootProfileAbor = this.rootProfileAbortController) === null || _this$rootProfileAbor === void 0 ? void 0 : _this$rootProfileAbor.abort();
    this.rootProfileAbortController = abortController;
    let context = this.rootProfileService.defaultContext;
    try {
      context = await this.rootProfileService.resolve(params);
    } catch (e) {
      (0, _utils.logResolutionError)(_consts.ContextualProfileLevel.rootLevel, serializedParams, e);
    }
    if (abortController.signal.aborted) {
      return {
        getRenderAppWrapper: this.rootProfile.getRenderAppWrapper,
        getDefaultAdHocDataViews: this.rootProfile.getDefaultAdHocDataViews
      };
    }
    this.rootContext$.next(context);
    this.prevRootProfileParams = serializedParams;
    return {
      getRenderAppWrapper: this.rootProfile.getRenderAppWrapper,
      getDefaultAdHocDataViews: this.rootProfile.getDefaultAdHocDataViews
    };
  }

  /**
   * Creates a profiles manager instance scoped to a single tab with a shared root context
   * @returns The scoped profiles manager
   */
  createScopedProfilesManager({
    scopedEbtManager
  }) {
    return new _scoped_profiles_manager.ScopedProfilesManager(this.rootContext$, () => this.rootProfile, this.dataSourceProfileService, this.documentProfileService, scopedEbtManager);
  }
}
exports.ProfilesManager = ProfilesManager;
const serializeRootProfileParams = params => {
  return {
    solutionNavId: params.solutionNavId
  };
};