"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityTimelineRedirectUrl = void 0;
var _rison = require("@kbn/rison");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSecurityTimelineRedirectUrl = ({
  from,
  to,
  index,
  eventId,
  baseURL
}) => {
  let timelineTimerangeSearchParam = {};
  if (from && to) {
    timelineTimerangeSearchParam = {
      timeline: {
        timerange: {
          from,
          to,
          kind: 'absolute',
          linkTo: false
        }
      }
    };
  }
  const query = {
    kind: 'kuery',
    expression: `_id: ${eventId}`
  };
  const timelineSearchParam = {
    activeTab: 'query',
    query,
    isOpen: true
  };
  const timelineFlyoutSearchParam = {
    right: {
      id: 'document-details-right',
      params: {
        id: eventId,
        indexName: index,
        scopeId: 'timeline-1'
      }
    }
  };
  const encodedTimelineParam = (0, _rison.encode)(timelineSearchParam);
  const encodedTimelineTimerangeParam = (0, _rison.encode)(timelineTimerangeSearchParam);
  const encodedTimelineFlyoutParam = (0, _rison.encode)(timelineFlyoutSearchParam);
  const urlParams = new URLSearchParams({
    timeline: encodedTimelineParam,
    timerange: encodedTimelineTimerangeParam,
    timelineFlyout: encodedTimelineFlyoutParam
  });
  return `${baseURL}?${urlParams.toString()}`;
};
exports.getSecurityTimelineRedirectUrl = getSecurityTimelineRedirectUrl;