"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTracesDataSourceProfileProvider = void 0;
var _constants = require("../../../../../common/constants");
var _profiles = require("../../../profiles");
var _extract_index_pattern_from = require("../../extract_index_pattern_from");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OBSERVABILITY_TRACES_DATA_SOURCE_PROFILE_ID = 'observability-traces-data-source-profile';
const createTracesDataSourceProfileProvider = ({
  tracesContextService
}) => ({
  profileId: OBSERVABILITY_TRACES_DATA_SOURCE_PROFILE_ID,
  restrictedToProductFeature: _constants.TRACES_PRODUCT_FEATURE_ID,
  profile: {
    getDefaultAppState: prev => params => ({
      ...prev(params),
      columns: [{
        name: '@timestamp',
        width: 212
      }, {
        name: '_source'
      }],
      rowHeight: 5
    }),
    getCellRenderers: _accessors.getCellRenderers,
    getColumnsConfiguration: _accessors.getColumnsConfiguration
  },
  resolve: params => {
    if (params.rootContext.solutionType === _profiles.SolutionType.Observability && tracesContextService.isTracesIndexPattern((0, _extract_index_pattern_from.extractIndexPatternFrom)(params))) {
      return {
        isMatch: true,
        context: {
          category: _profiles.DataSourceCategory.Traces
        }
      };
    }
    return {
      isMatch: false
    };
  }
});
exports.createTracesDataSourceProfileProvider = createTracesDataSourceProfileProvider;