"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnifiedHistogramRuntimeState = void 0;
var _react = require("react");
var _redux = require("../../state_management/redux");
var _use_discover_histogram = require("./use_discover_histogram");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useUnifiedHistogramRuntimeState = (stateContainer, localStorageKeyPrefix) => {
  const currentTabId = (0, _redux.useCurrentTabSelector)(tab => tab.id);
  const [options] = (0, _react.useState)(() => {
    const layoutPropsMap = (0, _redux.selectInitialUnifiedHistogramLayoutPropsMap)(stateContainer.runtimeStateManager, currentTabId);
    return {
      initialLayoutProps: layoutPropsMap[localStorageKeyPrefix !== null && localStorageKeyPrefix !== void 0 ? localStorageKeyPrefix : _redux.DEFAULT_HISTOGRAM_KEY_PREFIX]
    };
  });
  const unifiedHistogramProps = (0, _use_discover_histogram.useDiscoverHistogram)(stateContainer, options);
  return {
    currentTabId,
    unifiedHistogramProps
  };
};
exports.useUnifiedHistogramRuntimeState = useUnifiedHistogramRuntimeState;