"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsStats = getDataStreamsStats;
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsStats({
  esClient,
  dataStreams
}) {
  if (!dataStreams.length) {
    return {};
  }
  const matchingDataStreamsStats = _services.dataStreamService.getStreamsStats(esClient, dataStreams);
  const indicesDocsCount = _services.indexStatsService.getIndicesDocCounts(esClient, dataStreams);
  const [indicesDocsCountStats, dataStreamsStats] = await Promise.all([indicesDocsCount, matchingDataStreamsStats]);
  return dataStreamsStats.reduce((acc, dataStream) => ({
    ...acc,
    [dataStream.data_stream]: {
      size: dataStream.store_size.toString(),
      sizeBytes: dataStream.store_size_bytes,
      totalDocs: indicesDocsCountStats.docsCountPerDataStream[dataStream.data_stream]
    }
  }), {});
}