"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DegradedFieldFlyout;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _field_info = require("../field_info");
var _possible_mitigations = require("./possible_mitigations");
var _field_info2 = require("./field_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function DegradedFieldFlyout() {
  const {
    expandedDegradedField,
    renderedItems
  } = (0, _hooks.useQualityIssues)();
  const {
    dataStreamSettings
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const fieldList = (0, _react.useMemo)(() => {
    return renderedItems.find(item => {
      return item.name === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name) && item.type === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type);
    });
  }, [renderedItems, expandedDegradedField]);
  const isUserViewingTheIssueOnLatestBackingIndex = (dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.lastBackingIndexName) === (fieldList === null || fieldList === void 0 ? void 0 : fieldList.indexFieldWasLastPresentIn);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_info.QualityIssueFieldInfo, {
    fieldList: fieldList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_info2.DegradedFieldInfo, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })), isUserViewingTheIssueOnLatestBackingIndex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_possible_mitigations.PossibleDegradedFieldMitigations, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  })));
}
module.exports = exports.default;