"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsPanel = void 0;
var _react = require("@emotion/react");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _kibana_context = require("../../../kibana_context");
var _link_card = require("../../../common/components/link_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/actions_panel/actions_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ACTIONS_PANEL_WIDTH = '240px';
const ActionsPanel = ({
  dataView,
  searchString,
  searchQueryLanguage,
  getAdditionalLinks
}) => {
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const [discoverLink, setDiscoverLink] = (0, _react2.useState)('');
  const [asyncHrefCards, setAsyncHrefCards] = (0, _react2.useState)();
  const {
    services: {
      data,
      application: {
        capabilities
      },
      share: {
        url
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  (0, _react2.useEffect)(() => {
    let unmounted = false;
    const dataViewId = dataView.id;
    const dataViewIndexPattern = dataView.getIndexPattern();
    const getDiscoverUrl = async () => {
      var _capabilities$discove, _capabilities$discove2, _data$query$filterMan;
      const isDiscoverAvailable = (_capabilities$discove = (_capabilities$discove2 = capabilities.discover_v2) === null || _capabilities$discove2 === void 0 ? void 0 : _capabilities$discove2.show) !== null && _capabilities$discove !== void 0 ? _capabilities$discove : false;
      if (!isDiscoverAvailable) return;
      const discoverLocator = url === null || url === void 0 ? void 0 : url.locators.get('DISCOVER_APP_LOCATOR');
      if (!discoverLocator) {
        // eslint-disable-next-line no-console
        console.error('Discover locator not available');
        return;
      }
      const discoverUrl = await discoverLocator.getUrl({
        indexPatternId: dataViewId,
        filters: (_data$query$filterMan = data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [],
        query: searchString && searchQueryLanguage !== undefined ? {
          query: searchString,
          language: searchQueryLanguage
        } : undefined,
        timeRange: globalState !== null && globalState !== void 0 && globalState.time ? globalState.time : undefined,
        refreshInterval: globalState !== null && globalState !== void 0 && globalState.refreshInterval ? globalState.refreshInterval : undefined
      });
      if (unmounted) return;
      setDiscoverLink(discoverUrl);
    };
    if (Array.isArray(getAdditionalLinks) && dataViewId !== undefined) {
      Promise.all(getAdditionalLinks.map(async asyncCardGetter => {
        const results = await asyncCardGetter({
          dataViewId,
          dataViewTitle: dataViewIndexPattern
        });
        if (Array.isArray(results)) {
          return await Promise.all(results.map(async c => ({
            ...c,
            canDisplay: await c.canDisplay(),
            href: await c.getUrl()
          })));
        }
      })).then(cards => {
        setAsyncHrefCards((0, _lodash.flatten)(cards).filter(_mlIsDefined.isDefined).filter(d => d.canDisplay === true));
      });
    }
    getDiscoverUrl();
    return () => {
      unmounted = true;
    };
  }, [dataView, searchString, searchQueryLanguage, globalState, capabilities, url, data.query, getAdditionalLinks]);
  const showActionsPanel = discoverLink || Array.isArray(asyncHrefCards) && asyncHrefCards.length > 0;
  const dvActionsPanel = (0, _react.css)({
    [(0, _eui.useEuiBreakpoint)(['xl', 'xxl'])]: {
      width: ACTIONS_PANEL_WIDTH
    },
    width: '100%'
  });
  // Note we use display:none for the DataRecognizer section as it needs to be
  // passed the recognizerResults object, and then run the recognizer check which
  // controls whether the recognizer section is ultimately displayed.
  return showActionsPanel ? /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "dataVisualizerActionsPanel",
    css: dvActionsPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.index.actionsPanel.exploreTitle",
    defaultMessage: "Explore your data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), discoverLink && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_link_card.LinkCard, {
    href: discoverLink,
    icon: "discoverApp",
    description: _i18n.i18n.translate('xpack.dataVisualizer.index.actionsPanel.viewIndexInDiscoverDescription', {
      defaultMessage: 'Explore the documents in your index.'
    }),
    title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.index.actionsPanel.discoverAppTitle",
      defaultMessage: "Discover",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 15
      }
    }),
    "data-test-subj": "dataVisualizerViewInDiscoverCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })), Array.isArray(asyncHrefCards) && asyncHrefCards.map(link => /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    key: `dv-action-card-${link.title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_link_card.LinkCard, {
    href: link.href,
    icon: link.icon,
    description: link.description,
    title: link.title,
    "data-test-subj": link['data-test-subj'],
    key: link.href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  })))) : null;
};
exports.ActionsPanel = ActionsPanel;