"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fileUpload = require("@kbn/file-upload");
var _i18nReact = require("@kbn/i18n-react");
var _index_input = require("./index_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/index_selection/index_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexSelection = ({
  allowExistingIndices = true
}) => {
  const {
    setIndexName,
    setIndexValidationStatus,
    indexCreateMode,
    setIndexCreateMode,
    indices,
    existingIndexName,
    fileUploadManager
  } = (0, _fileUpload.useFileUploadContext)();
  const setSelectedOptions = (0, _react.useCallback)(selected => {
    fileUploadManager.setExistingIndexName(selected.length > 0 ? selected[0].label : null);
  }, [fileUploadManager]);
  const setIndexCreateModeWrapper = (0, _react.useCallback)(mode => {
    setIndexCreateMode(mode);
    if (mode === _fileUpload.UPLOAD_TYPE.NEW) {
      fileUploadManager.setExistingIndexName(null);
    }
  }, [setIndexCreateMode, fileUploadManager]);
  const selectedOptions = (0, _react.useMemo)(() => {
    if (existingIndexName === null) {
      return [];
    }
    return indices.filter(index => index.name === existingIndexName).map(index => ({
      label: index.name,
      value: index.name
    }));
  }, [existingIndexName, indices]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.indexSelectionTitle",
    defaultMessage: "Index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.indexChoiceDescription",
    defaultMessage: "An index stores your data and defines the field mappings for searches.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), allowExistingIndices === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.dataVisualizer.file.indexSelection.label', {
      defaultMessage: 'Select index creation method'
    }),
    isFullWidth: true,
    isDisabled: false,
    options: [{
      id: _fileUpload.UPLOAD_TYPE.NEW,
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.indexSelection.newLabel', {
        defaultMessage: 'Create new index'
      })
    }, {
      id: _fileUpload.UPLOAD_TYPE.EXISTING,
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.existingIndexSelection.label', {
        defaultMessage: 'Upload to existing index'
      })
    }],
    idSelected: indexCreateMode,
    onChange: id => setIndexCreateModeWrapper(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }), indexCreateMode === _fileUpload.UPLOAD_TYPE.NEW ? /*#__PURE__*/_react.default.createElement(_index_input.IndexInput, {
    setIndexName: setIndexName,
    setIndexValidationStatus: setIndexValidationStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.importView.selectExistingIndexLabel', {
      defaultMessage: 'Select existing index'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.existingIndexSelect.label', {
      defaultMessage: 'Select an index'
    }),
    options: indices.map(index => ({
      label: index.name,
      value: index.name
    })),
    selectedOptions: selectedOptions,
    onChange: selected => {
      setSelectedOptions(selected);
    },
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "defaultEditorAggSelect",
    isClearable: false,
    sortMatchesBy: "startsWith",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_index_input.IndexInput, {
    setIndexName: setIndexName,
    setIndexValidationStatus: setIndexValidationStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }));
};
exports.IndexSelection = IndexSelection;