"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeleteDataViewRouteLegacy = exports.registerDeleteDataViewRoute = exports.deleteDataView = void 0;
var _configSchema = require("@kbn/config-schema");
var _handle_errors = require("./util/handle_errors");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deleteDataView = async ({
  dataViewsService,
  usageCollection,
  counterName,
  id
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.delete(id);
};
exports.deleteDataView = deleteDataView;
const deleteIndexPatternRouteFactory = (path, description) => (router, getStartServices, usageCollection) => {
  router.versioned.delete({
    path,
    access: 'public',
    description,
    security: {
      authz: {
        requiredPrivileges: ['indexPatterns:manage']
      }
    }
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    validate: {
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            minLength: 1,
            maxLength: 1_000
          })
        }, {
          unknowns: 'allow'
        })
      }
    }
  }, router.handleLegacyErrors((0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const id = req.params.id;
    await deleteDataView({
      dataViewsService,
      usageCollection,
      counterName: `${req.route.method} ${path}`,
      id
    });
    return res.ok();
  })));
};
const registerDeleteDataViewRoute = exports.registerDeleteDataViewRoute = deleteIndexPatternRouteFactory(_constants.SPECIFIC_DATA_VIEW_PATH, _constants.DELETE_DATA_VIEW_DESCRIPTION);
const registerDeleteDataViewRouteLegacy = exports.registerDeleteDataViewRouteLegacy = deleteIndexPatternRouteFactory(_constants.SPECIFIC_DATA_VIEW_PATH_LEGACY);