"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardStorageCreateResultSchema = exports.dashboardCreateOptionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardCreateOptionsSchema = exports.dashboardCreateOptionsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.id),
  overwrite: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.overwrite),
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_common.referenceSchema)),
  initialNamespaces: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.initialNamespaces)
});
const dashboardStorageCreateResultSchema = exports.dashboardStorageCreateResultSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  data: _common.dashboardDataAttributesSchema,
  meta: _common.dashboardMetaSchema.extends(_common.dashboardResolveMetaSchema)
}, {
  unknowns: 'forbid'
});