"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _rxjs = require("rxjs");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationContainers.apiCanExpandPanels)(api.parentApi));
class ExpandPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_EXPAND_PANEL);
    (0, _defineProperty2.default)(this, "order", 9);
    (0, _defineProperty2.default)(this, "grouping", [_constants.DASHBOARD_ACTION_GROUP]);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return embeddable.parentApi.expandedPanelId$.value ? _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMinimizeTitle() : _dashboard_actions_strings.dashboardExpandPanelActionStrings.getMaximizeTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return embeddable.parentApi.expandedPanelId$.value ? 'minimize' : 'expand';
  }
  async isCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _presentationPublishing.apiHasParentApi)(embeddable) && (0, _presentationContainers.apiCanExpandPanels)(embeddable.parentApi);
  }
  getCompatibilityChangesSubject({
    embeddable
  }) {
    return isApiCompatible(embeddable) ? embeddable.parentApi.expandedPanelId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.map)(() => undefined)) : undefined;
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    embeddable.parentApi.expandPanel(embeddable.uuid);
  }
}
exports.ExpandPanelAction = ExpandPanelAction;