"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMarkdownPlugin = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class DashboardMarkdownPlugin {
  setup(core, {
    embeddable
  }) {
    embeddable.registerReactEmbeddableFactory(_constants.MARKDOWN_ID, async () => {
      const {
        markdownEmbeddableFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return markdownEmbeddableFactory;
    });
  }
  start(core, deps) {
    deps.uiActions.addTriggerActionAsync(_public2.ADD_PANEL_TRIGGER, _constants.ADD_MARKDOWN_ACTION_ID, async () => {
      const {
        createMarkdownAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return createMarkdownAction();
    });
    deps.uiActions.addTriggerActionAsync(_public.CONTEXT_MENU_TRIGGER, _constants.CONVERT_LEGACY_MARKDOWN_ACTION_ID, async () => {
      const {
        getConvertLegacyMarkdownAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
      return getConvertLegacyMarkdownAction();
    });
  }
  stop() {}
}
exports.DashboardMarkdownPlugin = DashboardMarkdownPlugin;