"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastsTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _event_types = require("./event_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ToastsTelemetry {
  constructor() {
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
  }
  setup({
    analytics
  }) {
    _event_types.eventTypes.forEach(eventType => {
      analytics.registerEventType(eventType);
    });
    return {};
  }
  start({
    analytics
  }) {
    this.reportEvent = analytics.reportEvent;
    return {
      onDismissToast: this.onDismissToast.bind(this)
    };
  }
  onDismissToast({
    recurrenceCount,
    toastMessage,
    toastMessageType
  }) {
    var _ref;
    (_ref = this.reportEvent) === null || _ref === void 0 ? void 0 : _ref(_event_types.EventMetric.TOAST_DISMISSED, {
      [_event_types.FieldType.RECURRENCE_COUNT]: recurrenceCount,
      [_event_types.FieldType.TOAST_MESSAGE]: toastMessage,
      [_event_types.FieldType.TOAST_MESSAGE_TYPE]: toastMessageType
    });
  }
}
exports.ToastsTelemetry = ToastsTelemetry;