"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorToast = ErrorToast;
exports.showErrorDialog = showErrorDialog;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/notifications/browser-internal/src/toasts/error_toast.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const isRequestError = e => {
  if ('body' in e) {
    var _e$body, _e$body$attributes, _e$body$attributes$er;
    return ((_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$attributes = _e$body.attributes) === null || _e$body$attributes === void 0 ? void 0 : (_e$body$attributes$er = _e$body$attributes.error) === null || _e$body$attributes$er === void 0 ? void 0 : _e$body$attributes$er.caused_by) !== undefined;
  }
  return false;
};

/**
 * This should instead be replaced by the overlay service once it's available.
 * This does not use React portals so that if the parent toast times out, this modal
 * does not disappear. NOTE: this should use a global modal in the overlay service
 * in the future.
 */
function showErrorDialog({
  title,
  error,
  openModal,
  rendering
}) {
  let text = '';
  if (isRequestError(error)) {
    var _error$body, _error$body$attribute, _error$body$attribute2, _error$body2, _error$body2$attribut, _error$body2$attribut2;
    text += `${error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : (_error$body$attribute2 = _error$body$attribute.error) === null || _error$body$attribute2 === void 0 ? void 0 : _error$body$attribute2.caused_by.type}\n`;
    text += `${error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$attribut = _error$body2.attributes) === null || _error$body2$attribut === void 0 ? void 0 : (_error$body2$attribut2 = _error$body2$attribut.error) === null || _error$body2$attribut2 === void 0 ? void 0 : _error$body2$attribut2.caused_by.reason}\n\n`;
  }
  if (error.stack) {
    text += error.stack;
  }
  const modal = openModal(mount(rendering.addContext(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    "data-test-subj": "errorModalBody",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "error",
    title: error.message,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }), text && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, text))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => modal.close(),
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.notifications.errorToast.closeModal",
    defaultMessage: "Close",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })))))));
}
function ErrorToast({
  title,
  error,
  toastMessage,
  openModal,
  rendering
}) {
  return rendering.addContext(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "errorToastMessage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, toastMessage), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    color: "danger",
    "data-test-subj": "errorToastBtn",
    onClick: () => showErrorDialog({
      title,
      error,
      openModal,
      rendering
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.toasts.errorToast.seeFullError",
    defaultMessage: "See the full error",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  })))));
}
const mount = component => container => {
  _reactDom.default.render(component, container);
  return () => _reactDom.default.unmountComponentAtNode(container);
};