"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigation = void 0;
var _react = require("react");
var _get_initial_active_items = require("../utils/get_initial_active_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useNavigation = (isCollapsed, items, logoId, activeItemId) => {
  const {
    primaryItem,
    secondaryItem,
    isLogoActive
  } = (0, _react.useMemo)(() => (0, _get_initial_active_items.getActiveItems)(items, activeItemId, logoId), [items, activeItemId, logoId]);
  const actualActiveItemId = activeItemId;
  const visuallyActivePageId = isLogoActive ? logoId : primaryItem === null || primaryItem === void 0 ? void 0 : primaryItem.id;
  const visuallyActiveSubpageId = secondaryItem === null || secondaryItem === void 0 ? void 0 : secondaryItem.id;
  const openerNode = primaryItem;
  const isSidePanelOpen = !isCollapsed && !!(openerNode !== null && openerNode !== void 0 && openerNode.sections);
  const state = {
    actualActiveItemId,
    visuallyActivePageId,
    visuallyActiveSubpageId,
    openerNode,
    isCollapsed,
    isSidePanelOpen
  };
  return state;
};
exports.useNavigation = useNavigation;