"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FixedLayoutProjectSideNavV2 = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react2 = require("@emotion/react");
var _navigation = require("./navigation");
var _collapse_button = require("./collapse_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/sidenav_v2/fixed_layout_sidenav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FixedLayoutProjectSideNavV2 = ({
  toggle,
  isCollapsed$,
  navProps,
  side
}) => {
  const isCollapsed = (0, _useObservable.default)(isCollapsed$, isCollapsed$.getValue());
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapse_button.SideNavV2CollapseButton, {
    isCollapsed: isCollapsed,
    toggle: toggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CollapsibleNavigationFlyout, {
    side: side,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, ({
    setWidth
  }) => /*#__PURE__*/_react.default.createElement(_navigation.Navigation, (0, _extends2.default)({}, navProps, {
    isCollapsed: isCollapsed,
    setWidth: setWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }))));
};
exports.FixedLayoutProjectSideNavV2 = FixedLayoutProjectSideNavV2;
const CollapsibleNavigationFlyout = ({
  children,
  side = 'left'
}) => {
  const [width, setWidth] = _react.default.useState(0);
  const childrenProps = _react.default.useMemo(() => ({
    setWidth
  }), [setWidth]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: (0, _react2.css)`
          :root {
            // have to provide this fallback to avoid bugs when EuiCollapsibleNavBeta is missing
            --euiCollapsibleNavOffset: ${width}px;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: width,
    side: side,
    type: 'push',
    paddingSize: "none",
    pushMinBreakpoint: "xs",
    hideCloseButton: true,
    onClose: () => {},
    className: "hide-for-sharing",
    css: (0, _react2.css)`
          border-inline-end: none; // Remove default euiFlyout border when used as a sidenav
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      height: '100%',
      display: 'flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, children(childrenProps))));
};