"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSearchTechnique = exports.getCompatibleSearchTechniques = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDefaultSearchTechnique = type => {
  const compatibleSearchTechniques = getCompatibleSearchTechniques(type);
  return compatibleSearchTechniques.length > 0 ? compatibleSearchTechniques[0] : undefined;
};
exports.getDefaultSearchTechnique = getDefaultSearchTechnique;
const getCompatibleSearchTechniques = type => {
  switch (type) {
    case 'string':
      {
        return ['prefix', 'wildcard', 'exact'];
      }
    case 'ip':
      {
        return ['prefix', 'exact'];
      }
    case 'number':
      {
        return ['exact'];
      }
    default:
      {
        return [];
      }
  }
};
exports.getCompatibleSearchTechniques = getCompatibleSearchTechniques;