"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncsLogic = void 0;
var _kea = require("kea");
var _cancel_syncs_api_logic = require("../../../api/connector/cancel_syncs_api_logic");
var _start_access_control_sync_api_logic = require("../../../api/connector/start_access_control_sync_api_logic");
var _start_incremental_sync_api_logic = require("../../../api/connector/start_incremental_sync_api_logic");
var _start_sync_api_logic = require("../../../api/connector/start_sync_api_logic");
var _connector_helpers = require("../../../utils/connector_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncsLogic = exports.SyncsLogic = (0, _kea.kea)({
  key: props => props.http,
  actions: {
    cancelSyncs: connector => ({
      connector
    }),
    startAccessControlSync: connector => ({
      connector
    }),
    startIncrementalSync: connector => ({
      connector
    }),
    startSync: connector => ({
      connector
    })
  },
  connect: {
    actions: [_cancel_syncs_api_logic.CancelSyncsApiLogic, ['apiError as cancelSyncsApiError', 'apiSuccess as cancelSyncsApiSuccess', 'makeRequest as makeCancelSyncsRequest'], _start_access_control_sync_api_logic.StartAccessControlSyncApiLogic, ['makeRequest as makeStartAccessControlSyncRequest'], _start_incremental_sync_api_logic.StartIncrementalSyncApiLogic, ['makeRequest as makeStartIncrementalSyncRequest'], _start_sync_api_logic.StartSyncApiLogic, ['makeRequest as makeStartSyncRequest']]
  },
  listeners: ({
    actions,
    props
  }) => ({
    cancelSyncs: ({
      connector
    }) => {
      if (connector !== null && connector !== void 0 && connector.id) {
        actions.makeCancelSyncsRequest({
          connectorId: connector.id,
          http: props.http
        });
      }
    },
    startAccessControlSync: ({
      connector
    }) => {
      if (connector !== null && connector !== void 0 && connector.id && (0, _connector_helpers.hasDocumentLevelSecurityFeature)(connector)) {
        actions.makeStartAccessControlSyncRequest({
          connectorId: connector.id,
          http: props.http
        });
      }
    },
    startIncrementalSync: ({
      connector
    }) => {
      if (connector !== null && connector !== void 0 && connector.id && (0, _connector_helpers.hasIncrementalSyncFeature)(connector)) {
        actions.makeStartIncrementalSyncRequest({
          connectorId: connector.id,
          http: props.http
        });
      }
    },
    startSync: ({
      connector
    }) => {
      if (connector !== null && connector !== void 0 && connector.id) {
        actions.makeStartSyncRequest({
          connectorId: connector.id,
          http: props.http
        });
      }
    }
  })
});