"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelSync = exports.CancelSyncApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cancelSync = async ({
  syncJobId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${syncJobId}/cancel_sync`;
  return await (http === null || http === void 0 ? void 0 : http.put(route));
};
exports.cancelSync = cancelSync;
const CancelSyncApiLogic = exports.CancelSyncApiLogic = (0, _create_api_logic.createApiLogic)(['cancel_sync_api_logic'], cancelSync, {
  showErrorFlash: true,
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.cancelSync.successMessage', {
    defaultMessage: 'Successfully canceled sync'
  })
});