"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddableConsoleStyleVariables = exports.useEmbeddableConsoleContentStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useEmbeddableConsoleStyleVariables = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDark = (0, _eui.useIsDarkMode)();
  const background = isDark ? euiTheme.colors.ink : euiTheme.colors.darkestShade;
  const baseTextColor = (0, _eui.makeHighContrastColor)(euiTheme.colors.lightestShade)(background);
  const text = (0, _eui.tint)(baseTextColor, 0.2);
  const initialHeight = euiTheme.size.xxl;
  const maxHeight = `calc(${(0, _coreChromeLayoutConstants.layoutVar)('application.content.height', '100vh')} - ${euiTheme.size.base})`;
  return {
    background,
    text,
    initialHeight,
    maxHeight
  };
};
exports.useEmbeddableConsoleStyleVariables = useEmbeddableConsoleStyleVariables;
const useEmbeddableConsoleContentStyles = () => {
  const {
    initialHeight
  } = useEmbeddableConsoleStyleVariables();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollBarStyle = (0, _eui.useEuiScrollBar)();
  return (0, _react.css)`
    ${scrollBarStyle}
    overflow-y: auto;
    width: 100%;
    height: calc(100% - ${initialHeight});
    background-color: ${euiTheme.colors.body};
    animation-name: embeddableConsoleShowContent;
    animation-duration: ${euiTheme.animation.slow};
    animation-iteration-count: 1;
    animation-timing-function: ${euiTheme.animation.resistance};
    color: ${euiTheme.colors.darkestShade};

    #consoleRoot {
      height: 100%;
    }

    @keyframes embeddableConsoleShowContent {
      0% {
        opacity: 0;
      }

      100% {
        opacity: 1;
      }
    }
  `;
};
exports.useEmbeddableConsoleContentStyles = useEmbeddableConsoleContentStyles;