"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignment = Assignment;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _color_mapping = require("../../state/color_mapping");
var _range = require("./range");
var _match = require("./match");
var _color_swatch = require("../color_picker/color_swatch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/assignment/assignment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function Assignment({
  data,
  assignment,
  assignments,
  disableDelete,
  index,
  palette,
  palettes,
  colorMode,
  isDarkMode,
  specialTokens,
  formatter,
  allowCustomMatch,
  assignmentMatcher
}) {
  var _assignment$rules$;
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "assignment",
    isDarkMode: isDarkMode,
    swatchShape: "square",
    colorMode: colorMode,
    assignmentColor: assignment.color,
    index: index,
    palette: palette,
    palettes: palettes,
    total: assignments.length,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateAssignmentColor)({
        assignmentIndex: index,
        color
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })), ((_assignment$rules$ = assignment.rules[0]) === null || _assignment$rules$ === void 0 ? void 0 : _assignment$rules$.type) === 'range' ? /*#__PURE__*/_react.default.createElement(_range.Range, {
    rule: assignment.rules[0],
    updateValue: (min, max, minInclusive, maxInclusive) => {
      const rule = {
        type: 'range',
        min,
        max,
        minInclusive,
        maxInclusive
      };
      dispatch((0, _color_mapping.updateAssignmentRules)({
        assignmentIndex: index,
        rules: [rule]
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_match.Match, {
    index: index,
    rules: assignment.rules,
    categories: data.type === 'categories' ? data.categories : [],
    specialTokens: specialTokens,
    formatter: formatter,
    allowCustomMatch: allowCustomMatch,
    assignmentMatcher: assignmentMatcher,
    updateRules: rules => {
      dispatch((0, _color_mapping.updateAssignmentRules)({
        assignmentIndex: index,
        rules
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    size: "xs",
    disabled: disableDelete,
    onClick: () => dispatch((0, _color_mapping.removeAssignment)(index)),
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.assignments.deleteAssignmentButtonLabel', {
      defaultMessage: 'Delete this assignment'
    }),
    color: "danger",
    css: !disableDelete ? (0, _react2.css)`
                  color: ${_uiTheme.euiThemeVars.euiTextColor};
                  transition: ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ease-in-out;
                  transition-property: color;
                  &:hover,
                  &:focus {
                    color: ${_uiTheme.euiThemeVars.euiColorDangerText};
                  }
                ` : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  })));
}