"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssignmentColor = getAssignmentColor;
exports.getColor = getColor;
exports.getColorFactory = getColorFactory;
exports.getGradientColorScale = getGradientColorScale;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _palettes = require("@kbn/palettes");
var _common = require("@kbn/data-plugin/common");
var _color_math = require("./color_math");
var _default_color_mapping = require("../config/default_color_mapping");
var _color_assignment_matcher = require("./color_assignment_matcher");
var _utils = require("./utils");
var _utils2 = require("../config/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FALLBACK_ASSIGNMENT_COLOR = 'red';
function getAssignmentColor(colorMode, color, palettes, isDarkMode, index, total) {
  switch (color.type) {
    case 'colorCode':
    case 'categorical':
    case 'loop':
      return getColor(color, palettes);
    case 'gradient':
      {
        if (colorMode.type === 'categorical') {
          return FALLBACK_ASSIGNMENT_COLOR;
        }
        const colorScale = getGradientColorScale(colorMode, palettes, isDarkMode);
        return total === 0 ? FALLBACK_ASSIGNMENT_COLOR : total === 1 ? colorScale(0) : colorScale(index / (total - 1));
      }
    default:
      return FALLBACK_ASSIGNMENT_COLOR;
  }
}
function getColor(color, palettes) {
  return color.type === 'colorCode' ? color.colorCode : (0, _color_math.getValidColor)(palettes.get(color.paletteId).getColor(color.colorIndex)).hex();
}

/**
 * Returns a color given a raw value
 */

function getColorFactory({
  assignments,
  specialAssignments,
  colorMode,
  paletteId
}, palettes, isDarkMode, data) {
  const lastCategorical = assignments.findLast(({
    color
  }) => color.type === 'categorical');
  const nextCategoricalIndex = (lastCategorical === null || lastCategorical === void 0 ? void 0 : lastCategorical.color.type) === 'categorical' ? lastCategorical.color.colorIndex + 1 : 0;
  const autoAssignments = assignments.filter(({
    rules
  }) => rules.length === 0).map((assignment, i) => ({
    assignment,
    assignmentIndex: i
  }));
  const assignmentMatcher = (0, _color_assignment_matcher.getColorAssignmentMatcher)(assignments);
  // find all categories that don't match with an assignment
  const unassignedAutoAssignmentsMap = new Map(data.type === 'categories' ? data.categories.map(category => (0, _common.deserializeField)(category)).filter(category => {
    return !assignmentMatcher.hasMatch(category);
  }).map((category, i) => {
    const key = (0, _utils.getValueKey)(category);
    const autoAssignment = autoAssignments[i];
    return [key, {
      ...autoAssignment,
      categoryIndex: i
    }];
  }) : []);
  return rawValue => {
    const key = (0, _utils.getValueKey)(rawValue);
    if (unassignedAutoAssignmentsMap.has(key)) {
      var _unassignedAutoAssign;
      const {
        assignment,
        assignmentIndex = -1,
        categoryIndex = -1
      } = (_unassignedAutoAssign = unassignedAutoAssignmentsMap.get(key)) !== null && _unassignedAutoAssign !== void 0 ? _unassignedAutoAssign : {};
      if (assignment) {
        // the category is within the number of available auto-assignments
        return getAssignmentColor(colorMode, assignment.color, palettes, isDarkMode, assignmentIndex, assignments.length);
      }

      // the category is not assigned to a specific color
      const totalColorsIfGradient = assignments.length || unassignedAutoAssignmentsMap.size;
      const indexIfGradient = (categoryIndex - autoAssignments.length) % totalColorsIfGradient;
      const otherColor = (0, _utils2.getOtherAssignmentColor)(specialAssignments, assignments);
      // if no auto-assign color rule/color is available then use the color looping palette
      return getAssignmentColor(colorMode, otherColor.isLoop ? colorMode.type === 'gradient' ? {
        type: 'gradient'
      } : {
        type: 'loop',
        // those are applied here and depends on the current non-assigned category - auto-assignment list
        colorIndex: categoryIndex - autoAssignments.length + nextCategoricalIndex,
        paletteId
      } : otherColor.color, palettes, isDarkMode, indexIfGradient, totalColorsIfGradient);
    }

    // find the assignment where the category matches the rule
    const matchingAssignmentIndex = assignmentMatcher.getIndex(rawValue);
    if (matchingAssignmentIndex > -1) {
      const assignment = assignments[matchingAssignmentIndex];
      return getAssignmentColor(colorMode, assignment.color, palettes, isDarkMode, matchingAssignmentIndex, assignments.length);
    }
    return getColor({
      type: 'categorical',
      paletteId: _palettes.KbnPalette.Neutral,
      colorIndex: _default_color_mapping.DEFAULT_NEUTRAL_PALETTE_INDEX
    }, palettes);
  };
}
function getGradientColorScale(colorMode, palettes, isDarkMode) {
  const steps = colorMode.steps.length === 1 ? [getColor(colorMode.steps[0], palettes), (0, _color_math.combineColors)((0, _color_math.changeAlpha)(getColor(colorMode.steps[0], palettes), 0.3), isDarkMode ? 'black' : 'white')] : colorMode.steps.map(d => getColor(d, palettes));
  if (colorMode.sort === 'asc') steps.reverse();
  const scale = _chromaJs.default.scale(steps).mode('lab');
  return value => scale(value).hex();
}