"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_refresh = require("@kbn/cloud-security-posture/src/hooks/use_refresh");
var _data_view_context = require("../../../common/contexts/data_view_context");
var _security_solution_context = require("../../../application/security_solution_context");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/layout/findings_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FindingsSearchBar = ({
  loading,
  query,
  setQuery,
  placeholder = _i18n.i18n.translate('xpack.csp.findings.searchBar.searchPlaceholder', {
    defaultMessage: 'Search findings (eg. rule.section : "API Server" )'
  }),
  refreshQueryKey
}) => {
  var _query$query, _query$query2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _public.useKibana)().services;
  const securitySolutionContext = (0, _react.useContext)(_security_solution_context.SecuritySolutionContext);
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const {
    refresh,
    isRefreshing
  } = (0, _use_refresh.useRefresh)(refreshQueryKey);
  let searchBarNode = /*#__PURE__*/_react.default.createElement("div", {
    css: getContainerStyle(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _common.PLUGIN_NAME,
    showFilterBar: true,
    showQueryInput: true,
    showDatePicker: false,
    isLoading: loading || isRefreshing,
    indexPatterns: [dataView],
    onQuerySubmit: (payload, isUpdated) => isUpdated ? setQuery(payload) : refresh(),
    onFiltersUpdated: value => setQuery({
      filters: value
    }),
    placeholder: placeholder,
    query: {
      query: (query === null || query === void 0 ? void 0 : (_query$query = query.query) === null || _query$query === void 0 ? void 0 : _query$query.query) || '',
      language: (query === null || query === void 0 ? void 0 : (_query$query2 = query.query) === null || _query$query2 === void 0 ? void 0 : _query$query2.language) || 'kuery'
    },
    filters: (query === null || query === void 0 ? void 0 : query.filters) || [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
  if (securitySolutionContext) {
    const FiltersGlobal = securitySolutionContext.getFiltersGlobalComponent();
    searchBarNode = /*#__PURE__*/_react.default.createElement(FiltersGlobal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 21
      }
    }, searchBarNode);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, searchBarNode);
};
exports.FindingsSearchBar = FindingsSearchBar;
const getContainerStyle = theme => (0, _react2.css)`
  border-bottom: ${theme.border.thin};
  background-color: ${theme.colors.body};
  padding: ${theme.size.base};
`;