"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIndexSynchronizationTaskFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _synchronization_task_runner = require("./synchronization_task_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnalyticsIndexSynchronizationTaskFactory {
  constructor({
    logger,
    getESClient,
    analyticsConfig
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "getESClient", void 0);
    (0, _defineProperty2.default)(this, "analyticsConfig", void 0);
    this.logger = logger;
    this.getESClient = getESClient;
    this.analyticsConfig = analyticsConfig;
  }
  create(context) {
    return new _synchronization_task_runner.SynchronizationTaskRunner({
      taskInstance: context.taskInstance,
      logger: this.logger,
      getESClient: this.getESClient,
      analyticsConfig: this.analyticsConfig
    });
  }
}
exports.AnalyticsIndexSynchronizationTaskFactory = AnalyticsIndexSynchronizationTaskFactory;