"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _case_form_fields = require("../case_form_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _template_fields = require("./template_fields");
var _use_cases_features = require("../../common/use_cases_features");
var _sync_alerts_toggle = require("../case_form_fields/sync_alerts_toggle");
var _observables_toggle = require("../case_form_fields/observables_toggle");
var _connector = require("../case_form_fields/connector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/templates/form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormFieldsComponent = ({
  isSubmitting = false,
  connectors,
  currentConfiguration,
  isEditMode,
  initialValue
}) => {
  var _initialValue$caseFie7, _initialValue$caseFie8, _initialValue$caseFie9, _initialValue$caseFie10;
  const {
    isSyncAlertsEnabled,
    isExtractObservablesEnabled,
    observablesAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    customFields: configurationCustomFields,
    templates
  } = currentConfiguration;
  const configurationTemplateTags = getTemplateTags(templates);
  const firstStep = (0, _react.useMemo)(() => ({
    title: i18n.TEMPLATE_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_template_fields.TemplateFields, {
      isLoading: isSubmitting,
      configurationTemplateTags: configurationTemplateTags,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    })
  }), [isSubmitting, configurationTemplateTags]);
  const secondStep = (0, _react.useMemo)(() => ({
    title: i18n.CASE_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_case_form_fields.CaseFormFields, {
      configurationCustomFields: configurationCustomFields,
      isLoading: isSubmitting,
      setCustomFieldsOptional: true,
      isEditMode: isEditMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    })
  }), [isSubmitting, configurationCustomFields, isEditMode]);
  const thirdStep = (0, _react.useMemo)(() => {
    var _initialValue$caseFie, _initialValue$caseFie2, _initialValue$caseFie3, _initialValue$caseFie4, _initialValue$caseFie5, _initialValue$caseFie6;
    return {
      title: i18n.CASE_SETTINGS,
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSyncAlertsEnabled && /*#__PURE__*/_react.default.createElement(_sync_alerts_toggle.SyncAlertsToggle, {
        isLoading: isSubmitting,
        defaultValue: (_initialValue$caseFie = initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$caseFie2 = initialValue.caseFields) === null || _initialValue$caseFie2 === void 0 ? void 0 : (_initialValue$caseFie3 = _initialValue$caseFie2.settings) === null || _initialValue$caseFie3 === void 0 ? void 0 : _initialValue$caseFie3.syncAlerts) !== null && _initialValue$caseFie !== void 0 ? _initialValue$caseFie : true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }), observablesAuthorized && isExtractObservablesEnabled && /*#__PURE__*/_react.default.createElement(_observables_toggle.ObservablesToggle, {
        isLoading: isSubmitting,
        defaultValue: (_initialValue$caseFie4 = initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$caseFie5 = initialValue.caseFields) === null || _initialValue$caseFie5 === void 0 ? void 0 : (_initialValue$caseFie6 = _initialValue$caseFie5.settings) === null || _initialValue$caseFie6 === void 0 ? void 0 : _initialValue$caseFie6.extractObservables) !== null && _initialValue$caseFie4 !== void 0 ? _initialValue$caseFie4 : true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 13
        }
      }))
    };
  }, [isSubmitting, initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$caseFie7 = initialValue.caseFields) === null || _initialValue$caseFie7 === void 0 ? void 0 : (_initialValue$caseFie8 = _initialValue$caseFie7.settings) === null || _initialValue$caseFie8 === void 0 ? void 0 : _initialValue$caseFie8.syncAlerts, initialValue === null || initialValue === void 0 ? void 0 : (_initialValue$caseFie9 = initialValue.caseFields) === null || _initialValue$caseFie9 === void 0 ? void 0 : (_initialValue$caseFie10 = _initialValue$caseFie9.settings) === null || _initialValue$caseFie10 === void 0 ? void 0 : _initialValue$caseFie10.extractObservables, isExtractObservablesEnabled, isSyncAlertsEnabled, observablesAuthorized]);
  const showThirdStep = isSyncAlertsEnabled || isExtractObservablesEnabled;
  const fourthStep = (0, _react.useMemo)(() => ({
    title: i18n.CONNECTOR_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_connector.Connector, {
      connectors: connectors,
      isLoading: isSubmitting,
      isLoadingConnectors: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    })
  }), [connectors, isSubmitting]);
  const allSteps = (0, _react.useMemo)(() => [firstStep, secondStep, ...(showThirdStep ? [thirdStep] : []), fourthStep], [firstStep, secondStep, thirdStep, fourthStep, showThirdStep]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "key",
    component: _components.HiddenField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: allSteps,
    "data-test-subj": 'template-creation-form-steps',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }));
};
FormFieldsComponent.displayName = 'FormFields';
const FormFields = exports.FormFields = /*#__PURE__*/(0, _react.memo)(FormFieldsComponent);
const getTemplateTags = templates => (0, _lodash.uniq)(templates.map(template => {
  var _template$tags;
  return template !== null && template !== void 0 && (_template$tags = template.tags) !== null && _template$tags !== void 0 && _template$tags.length ? template.tags : [];
}).flat());