"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_ATTRIBUTES_ERROR = exports.INVALID_JSON_FORMAT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_JSON_FORMAT = exports.INVALID_JSON_FORMAT = _i18n.i18n.translate('xpack.cases.connectors.serviceNow.additionalFieldsFormatErrorMessage', {
  defaultMessage: 'Invalid JSON.'
});
const MAX_ATTRIBUTES_ERROR = length => _i18n.i18n.translate('xpack.cases.connectors.serviceNow.additionalFieldsLengthError', {
  values: {
    length
  },
  defaultMessage: 'A maximum of {length} additional fields can be defined at a time.'
});
exports.MAX_ATTRIBUTES_ERROR = MAX_ATTRIBUTES_ERROR;