"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCaseConnectorsRegistry = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCaseConnectorsRegistry = () => {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const connectors = new Map();
  function assertConnectorExists(connector, id) {
    if (!connector) {
      throw new Error(_i18n.i18n.translate('xpack.cases.connecors.get.missingCaseConnectorErrorMessage', {
        defaultMessage: 'Object type "{id}" is not registered.',
        values: {
          id
        }
      }));
    }
  }
  const registry = {
    has: id => connectors.has(id),
    register: connector => {
      if (connectors.has(connector.id)) {
        throw new Error(_i18n.i18n.translate('xpack.cases.connecors.register.duplicateCaseConnectorErrorMessage', {
          defaultMessage: 'Object type "{id}" is already registered.',
          values: {
            id: connector.id
          }
        }));
      }
      connectors.set(connector.id, connector);
    },
    get: id => {
      const connector = connectors.get(id);
      assertConnectorExists(connector, id);
      return connector;
    },
    list: () => {
      return Array.from(connectors).map(([id, connector]) => connector);
    }
  };
  return registry;
};
exports.createCaseConnectorsRegistry = createCaseConnectorsRegistry;