"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRootReducer = getRootReducer;
var _redux = require("redux");
var _reduceReducers = _interopRequireDefault(require("reduce-reducers"));
var _lodash = require("lodash");
var _app = require("./app");
var _transient = require("./transient");
var _resolved_args = require("./resolved_args");
var _workpad = require("./workpad");
var _pages = require("./pages");
var _elements = require("./elements");
var _assets = require("./assets");
var _history = require("./history");
var _embeddable = require("./embeddable");
var _sidebar = require("./sidebar");
var _flyouts = require("./flyouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRootReducer(initialState) {
  return (0, _redux.combineReducers)({
    assets: _assets.assetsReducer,
    app: _app.appReducer,
    transient: (0, _reduceReducers.default)(_transient.transientReducer, _resolved_args.resolvedArgsReducer, _sidebar.sidebarReducer, _flyouts.flyoutsReducer),
    persistent: (0, _reduceReducers.default)(_history.historyReducer, (0, _redux.combineReducers)({
      workpad: (0, _reduceReducers.default)(_workpad.workpadReducer, _pages.pagesReducer, _elements.elementsReducer, _embeddable.embeddableReducer),
      schemaVersion: (state = (0, _lodash.get)(initialState, 'persistent.schemaVersion')) => state
    }))
  });
}