"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopColorPicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/palette_picker/stops_palette_picker/stop_color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getDeleteStopColorLabel: () => _i18n.i18n.translate('xpack.canvas.stopsColorPicker.deleteColorStopLabel', {
    defaultMessage: 'Delete'
  })
};
const isValidColorStop = colorStop => {
  const valid = !isNaN(colorStop.stop);
  return {
    valid,
    stop: valid,
    color: true
  };
};
const StopColorPicker = props => {
  const {
    stop,
    color,
    onDelete,
    onChange,
    removable = true
  } = props;
  const [colorStop, setColorStop] = (0, _react.useState)({
    stop: stop !== null && stop !== void 0 ? stop : 0,
    color: color !== null && color !== void 0 ? color : ''
  });
  const [areValidFields, setAreValidFields] = (0, _react.useState)({
    stop: true,
    color: true
  });
  const onChangeInput = updatedColorStop => {
    setColorStop(updatedColorStop);
  };
  const [, cancel] = (0, _useDebounce.default)(() => {
    if (color === colorStop.color && stop === colorStop.stop) {
      return;
    }
    const {
      valid,
      ...validationResult
    } = isValidColorStop(colorStop);
    if (!valid) {
      setAreValidFields(validationResult);
      return;
    }
    onChange(colorStop);
  }, 150, [colorStop]);
  (0, _react.useEffect)(() => {
    const newColorStop = {
      stop: stop !== null && stop !== void 0 ? stop : 0,
      color: color !== null && color !== void 0 ? color : ''
    };
    setColorStop(newColorStop);
    const {
      valid,
      ...validationResult
    } = isValidColorStop(newColorStop);
    setAreValidFields(validationResult);
  }, [color, stop]);
  (0, _react.useEffect)(() => {
    return () => {
      cancel();
    };
  }, [cancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: colorStop.stop,
    min: -Infinity,
    onChange: ({
      target: {
        valueAsNumber
      }
    }) => onChangeInput({
      ...colorStop,
      stop: valueAsNumber
    }),
    isInvalid: !areValidFields.stop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    secondaryInputDisplay: "top",
    color: colorStop.color,
    showAlpha: true,
    compressed: true,
    onChange: newColor => {
      onChangeInput({
        ...colorStop,
        color: newColor
      });
    },
    isInvalid: !areValidFields.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    title: strings.getDeleteStopColorLabel(),
    onClick: onDelete,
    isDisabled: !removable,
    "aria-label": strings.getDeleteStopColorLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  })));
};
exports.StopColorPicker = StopColorPicker;