"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnparseableCSVFormatError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCode = _constants.GenerationErrorCode.UNPARSEABLE_CSV_DATA;
class UnparseableCSVFormatError extends Error {
  constructor(csvParseErrors) {
    super(errorCode);
    (0, _defineProperty2.default)(this, "attributes", void 0);
    this.attributes = {
      errorCode,
      underlyingMessages: csvParseErrors.flatMap(error => error.message)
    };
  }
  sendResponse(res) {
    const body = {
      message: errorCode,
      attributes: this.attributes
    };
    return res.customError({
      statusCode: 422,
      body
    });
  }
}
exports.UnparseableCSVFormatError = UnparseableCSVFormatError;