"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpan = getSpan;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _lodash = require("lodash");
var _maybe = require("../../../../common/utils/maybe");
var _apm = require("../../../../common/es_fields/apm");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _get_transaction = require("../get_transaction");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSpan({
  spanId,
  traceId,
  parentTransactionId,
  apmEventClient,
  start,
  end
}) {
  const [spanResp, parentTransaction] = await Promise.all([apmEventClient.search('get_span', {
    apm: {
      events: [_common.ProcessorEvent.span]
    },
    track_total_hits: false,
    size: 1,
    terminate_after: 1,
    fields: ['*'],
    _source: [_apm.SPAN_STACKTRACE],
    query: {
      bool: {
        filter: (0, _as_mutable_array.asMutableArray)([{
          term: {
            [_apm.SPAN_ID]: spanId
          }
        }, ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.rangeQuery)(start, end)])
      }
    }
  }), parentTransactionId ? (0, _get_transaction.getTransaction)({
    apmEventClient,
    transactionId: parentTransactionId,
    traceId,
    start,
    end
  }) : undefined]);
  const hit = (0, _maybe.maybe)(spanResp.hits.hits[0]);
  const spanFromSource = hit && 'span' in hit._source ? hit._source : undefined;
  const event = (0, _utils.unflattenKnownApmEventFields)(hit === null || hit === void 0 ? void 0 : hit.fields);
  return {
    span: event ? (0, _lodash.merge)({}, (0, _lodash.omit)(event, 'span.links'), spanFromSource, {
      processor: {
        event: 'span',
        name: 'transaction'
      }
    }) : undefined,
    parentTransaction
  };
}