"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceMap = getServiceMap;
var _with_apm_span = require("../../utils/with_apm_span");
var _get_trace_sample_ids = require("./get_trace_sample_ids");
var _get_service_anomalies = require("./get_service_anomalies");
var _get_service_stats = require("./get_service_stats");
var _fetch_exit_span_samples = require("./fetch_exit_span_samples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getConnectionData({
  config,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  serviceGroupKuery,
  kuery,
  logger
}) {
  return (0, _with_apm_span.withApmSpan)('get_service_map_connections', async () => {
    logger.debug('Getting trace sample IDs');
    const {
      traceIds
    } = await (0, _get_trace_sample_ids.getTraceSampleIds)({
      config,
      apmEventClient,
      serviceName,
      environment,
      start,
      end,
      serviceGroupKuery,
      kuery
    });
    logger.debug(`Found ${traceIds.length} traces to inspect`);
    if (traceIds.length === 0) {
      return {
        spans: [],
        tracesCount: 0
      };
    }
    const spans = await (0, _with_apm_span.withApmSpan)('get_service_map_exit_spans_and_transactions_from_traces', () => (0, _fetch_exit_span_samples.fetchExitSpanSamplesFromTraceIds)({
      apmEventClient,
      traceIds,
      start,
      end
    }));
    return {
      tracesCount: traceIds.length,
      spans
    };
  });
}
function getServiceMap(options) {
  return (0, _with_apm_span.withApmSpan)('get_service_map', async () => {
    const {
      logger
    } = options;
    const anomaliesPromise = (0, _get_service_anomalies.getServiceAnomalies)(options

    // always catch error to avoid breaking service maps if there is a problem with ML
    ).catch(error => {
      logger.debug(`Unable to retrieve anomalies for service maps.`, {
        error
      });
      return _get_service_anomalies.DEFAULT_ANOMALIES;
    });
    const [connectionData, servicesData, anomalies] = await Promise.all([getConnectionData(options), (0, _get_service_stats.getServiceStats)(options), anomaliesPromise]);
    logger.debug('Received and parsed all responses');
    return {
      spans: connectionData.spans,
      tracesCount: connectionData.tracesCount,
      servicesData,
      anomalies
    };
  });
}