"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAgentsLatestVersion = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _error_with_status_code = require("./error_with_status_code");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISSING_CONFIGURATION = _i18n.i18n.translate('xpack.apm.agent_explorer.error.missing_configuration', {
  defaultMessage: 'To use latest agent versions you must set xpack.apm.latestAgentVersionsUrl.'
});
const fetchAgentsLatestVersion = async (logger, latestAgentVersionsUrl) => {
  if ((0, _lodash.isEmpty)(latestAgentVersionsUrl)) {
    throw _boom.default.notImplemented(MISSING_CONFIGURATION);
  }
  try {
    const response = await (0, _nodeFetch.default)(latestAgentVersionsUrl);
    if (response.status !== 200) {
      throw new _error_with_status_code.ErrorWithStatusCode(`${response.status} - ${await response.text()}`, `${response.status}`);
    }
    const data = await response.json();
    return {
      data
    };
  } catch (error) {
    const message = `Failed to retrieve latest APM Agent versions due to ${error}`;
    logger.warn(message);
    return {
      data: {},
      error
    };
  }
};
exports.fetchAgentsLatestVersion = fetchAgentsLatestVersion;